

/*


  Orthogonal Frequency Division Multiplexer


  */

#include "conf.h"
#include "fft.h"

/* indices for frequency interleaveing
   value 1..1536
   */
extern SHORT ofdm_freqtab[1536];

/* mapping of the eight possible qpsk-phases (real&imag-part) 
   will be defined in ofdm_init()
*/
extern FFT_TYPE ofdm_qpsksymbol[];


/* mapping 0..CarrierNbr-1 to -CarrierNbr/2..CarrierNbr/2 */
#define ofdm_realtraegermap(x) (((x)-CarrierNbr/2)+((x)>=(CarrierNbr/2)))
/* fftshift: -CarrierNbr/2..CarrierNbr/2 to 0..VirtualCarriers */
#define ofdm_fftshift(x) (((x)<0)*((x)+VirtualCarriers)+((x)>0)*(x))
#define ofdm_frqtab(x) (ofdm_freqtab[(x)])
void ofdm_dqpsk(WORD *data,FFT_TYPE *dest);
void ofdm_initfrqtab(int carriers);
void ofdm_initdiffmod(void);
void ofdm_init(void);

void Null_symbol(FFT_TYPE *dest);
void TII_symbol(int comb,int pattern,FFT_TYPE *dest);

#define tfpr_phiN(x) (tfpr_phi(ofdm_realtraegermap(x)))
void TFPR_Symbol(FFT_TYPE *dest);
void tfpr_init(void);
int tfpr_phi(int k);
