
/*

  fft

  */

#ifndef FFT_MIXED
#define FFT_MIXED

/* to specify FFT-algorithm, define either
   FFT_FLOAT or FFT_INT. Then set the desired type,
   (float,double,int,short int,...) to FFT_TYPE. Then define
   the specific type for integer , FFT_INT30,FFT_INT20,FFT_INT15
   */
#define FFT_INT_NOT
#define FFT_FLOAT
#define FFT_TYPE float
#define FFT_INT20_NOT
#define FFT_INT15_NOT

#define FFT_MAXSIZE 2048

extern FFT_TYPE fft_Wk[(5*FFT_MAXSIZE)/4];

/* used to debug multiply-overflow */
extern double fftmax;

void fft_mixed(FFT_TYPE *symb,int base);
void ifft_mixed(FFT_TYPE *symb,int base);
void fft_init(void);

#endif
