
/*

  fft

  */

#ifndef FFT_BURRUS
#define FFT_BURRUS

/* please delete the _NOT of your fft of choice and append _NOT to all others
   Working:
   FFT_INT15, FFT_FLOAT
*/
#define FFT_DOUBLE_NOT
#define FFT_FLOAT_NOT
#define FFT_INT15
#define FFT_SHORT_NOT

#define FFT_MAXSIZE 2048



#define sqrt_2 1.41421356237309514547
#define M_PI   3.14159265358979323846

#ifdef FFT_FLOAT
#define FFT_TYPE float
#endif

#ifdef FFT_DOUBLE
#define FFT_TYPE double
#define FFT_FLOAT
#endif

#ifdef FFT_FLOAT
#define FFT_ONE 1.0
#define FFT_HALF 0.5
#define FFT_FORTH 0.25
#define onedivsqrt2 0.707106781186547461715
#define FFT_MAXINT 1.0
#define MUL_SHIFT(a) (a)
#endif

#ifdef FFT_INT20
#define FFT_INT
#define FFT_TYPE int
#define FFT_ONE        524287
#define FFT_HALF       262144
#define FFT_FORTH      131072
#define onedivsqrt2_20 370728
#define FFT_MAXINT    1048575
#endif

#ifdef FFT_INT15
#define FFT_TYPE int
#endif

#ifdef FFT_SHORT
#define FFT_TYPE short
#define FFT_INT15
#endif

#ifdef FFT_INT15
#define FFT_INT
#define FFT_ONE        32767
#define FFT_HALF       16384
#define FFT_FORTH       8192
#define onedivsqrt2    23170
#define FFT_MAXINT     32767
#define MUL_SHIFT(a) (((a)+(1<<14))>>15)
#endif

#ifdef FFT_FLOAT
#define _FFT_PRINT(a,x) for(a=0;a<16;a++) printf(" %8.4f + ( %8.4f *j )\n",x[2*a],x[2*a+1])
#endif
#ifdef FFT_INT
#define _FFT_PRINT(a,x) for(a=0;a<16;a++) printf(" %8d + ( %8d *j )\n",x[2*a],x[2*a+1])
#endif


extern FFT_TYPE *fft_SIN;
extern FFT_TYPE *fft_COS;

void fft_r2(int n,FFT_TYPE *symb);
void ifft_r2(int n,FFT_TYPE *symb);
void ifft_r4(int n,FFT_TYPE *symb);
void fft_init(int size);
void fft_step2(int nn,int nn2,int nie,FFT_TYPE *real,FFT_TYPE *imag);
void fft_step4(int nn,int nn2,int ie,register FFT_TYPE *x,register FFT_TYPE *y);

#endif
