
/*

  eti_demux.c

  */

#ifndef ETI
#define ETI

#include "conf.h"

/* holds the sorted SubSTreamCharacterisation */
extern WORD eti_sort_SSTC[64];
/* holds the corresponding startadress in the MST to each channel */
extern WORD *eti_MSTadress[64];
extern WORD *eti_dataoffset;


int eti_ERR(WORD *eti_ni_frame);
int eti_FSYNC(WORD *eti_ni_frame);

int eti_FCT(WORD *eti_ni_frame);
int eti_FICF(WORD *eti_ni_frame);
int eti_NST(WORD *eti_ni_frame);
int eti_FP(WORD *eti_ni_frame);
int eti_MID(WORD *eti_ni_frame);
int eti_FL(WORD *eti_ni_frame);

/* these funcs work on the sorted SubSTreamCharacterisation copy 
   (make sure you called eti_sort_STC before)
   nr von 0 bis NST-1
*/
#define eti_SSTC(x)  (eti_sort_SSTC[(x)])
#define eti_SCID(x) ((eti_sort_SSTC[(x)]&0xfc000000)>>26)
#define eti_SAD(x)  ((eti_sort_SSTC[(x)]&0x03ff0000)>>16)
#define eti_TPL(x)  ((eti_sort_SSTC[(x)]&0x0000fc00)>>10)
#define eti_STL(x)   (eti_sort_SSTC[(x)]&0x000003ff)
#define eti_DATA(x)  (eti_MSTadress[(x)])
#define eti_DOFFSET(x)  (eti_MSTadress[(x)]-eti_dataoffset)

/*  these corresponding funcs work direct on eti-frames */
unsigned int eti_u_SSTC(WORD *eti_ni_frame,int nr);
int eti_u_SCID(WORD *eti_ni_frame,int nr);
int eti_u_SAD(WORD *eti_ni_frame,int nr);
int eti_u_TPL(WORD *eti_ni_frame,int nr);
int eti_u_STL(WORD *eti_ni_frame,int nr);

int eti_MNSC(WORD *eti_ni_frame);
int eti_CRCH(WORD *eti_ni_frame);
WORD *eti_FIC(WORD *eti_ni_frame);
int eti_CRCM(WORD *eti_ni_frame);
int eti_Rfu(WORD *eti_ni_frame);
unsigned int eti_TIST(WORD *eti_ni_frame);
void eti_sort_STC(WORD *eti_ni_frame);
int eti_checkcrch(WORD *eti_niframe);
int eti_checkcrcm(WORD *eti_niframe);

#endif
