function	rs_init(poly,rootoffset,l)
%
%	an init-routine for rs-correct
%
%	poly:	a binary polynom, used to define GF(q)
%		size(1,1..8);value[0,1]
%		(add-proc works only up to GF(256))
%
%	rootoffset: for your REED-SOLOMON-Code there
%		should be a generator polynomial,
%		defined by G= Produkt{i=offset:offset+l}(x-alpha^i)
%		offset is the rootoffset needed
%
%	l:	the number of RS-Symbols
%		(look at rootoffset for exact definition)
%
%	this routine intitializes
%	global gfq_expotab gfq_logatab gfq_n rs_roots rs_generator
%
%	after this routine has been called, you can call
%	rs_encode rs_correct

global gfq_expotab rs_roots rs_generator

% gfq_calctabs(poly);
rs_roots=gfq_expotab([rootoffset:rootoffset+l-1]'+1);
rs_generator=[1 rs_roots(1)];
for i=2:l
	rs_generator=gfq_polymulti(rs_generator,[1 rs_roots(i)]);
end

