function	[c,v]=rs_correct(msg)
%
%	given a msg and the roots of the generator polynomial in 
%	ascending order, this algorithm calculates the errors and
%	the corresponding corrected msg
%
%	Algorithms:
%	error_locator polynomial: berlekamp-massey
%	polynom factorization	: horner
%	error_magnitude		: forney
%
%	used variables gfq_logatab rs_roots

global gfq_logatab rs_roots

[l,x]=size(rs_roots);
msg=msg(:);
[m,x]=size(msg);
v=0;
t=floor(l/2);
c=msg;
offset=gfq_logatab(rs_roots(1));

for i=1:l
	syn(i)=gfq_syndrom(msg,rs_roots(i));
end
if (syn==zeros(1,l))
	disp('no errors found');
	return
end

% the A-poly is LSB-first!
A=berlekamp_locator(syn);

[x,k]=size(A);
disp([num2str(k-1),' errors found']);

% O is LSB-first (cause A and syn are)
% and is therefor inverted
O=gfq_polymulti(A,syn);
O=O(1:2*t);
O(2*t:-1:1)=O(1:2*t);

% Now A is mirrored
[x,u]=size(A);
A(u:-1:1)=A(1:u);

X=gfq_factors(A);
[x,v]=size(X);
if (v ~= k-1)
	disp('decoder error');
	return
end

Aderiv=zeros(x,u);
for i=u-1:-2:1
	Aderiv(i+1)=A(i);
end

disp(' -- -- ');
% forney
for i=1:v
	t0=X(i);			% Xk^-1
	t1=gfq_invert(t0);		% Xk

	% replaced Omega(x) with A(x)+A(x)*syn(x')*x'^offset
	t2a=gfq_syndrom(A,t0);		% A(Xk^-1)
	t2b=gfq_power(t0,offset);	% Xk^-offset
	t2c=gfq_syndrom(O,t0);
	t2d=gfq_multiplic(t2b,t2c);
	t2e=gfq_add(t2a,t2d);		% Omega(Xk^-1)

	t3=gfq_syndrom(Aderiv,t0);	% A'(Xk^-1)
	t4=gfq_multiplic(t1,t2e);	% =Zaehler
	t5=gfq_invert(t3);		% =Nenner^-1
	t6=gfq_multiplic(t5,t4);
	po=gfq_logatab(t1);		% error position

	c(m-po)=gfq_add(c(m-po),t6);
	disp(['error at x^',num2str(po),' value ',num2str(t6)]);
end
disp(' -- -- ');
