function	s=gfq_syndrom(msg,root)
%
% calculates msg(root)
% In errorfree transmissions all calculated
% values should be zero - insuring the given
% root is truly a root of the msg-polynomial.
%

global gfq_expotab gfq_logatab gfq_n

msg=msg(:);
[l,x]=size(msg);

if (root==0)
	s=msg(l);
	return
end

r=gfq_logatab(root);
s=0;
for j=1:l
	t1=msg(j);
	if (t1>0)
		t1=gfq_logatab(t1);
		t2=(l-j)*r+t1;
		t3=rem(t2,gfq_n);
		t4=gfq_expotab(t3+1);
		s=xor_bytes(s,t4);
	end
end

