function	roots=gfq_factors(poly)
%
%	factors the given poly over GF(q) and
%	writes out the roots. This algorithm
%	uses HORNER-scheme and checks systematically
%	all q values of GF(q) until the degree of poly is 1
%
%	+++ WARNING +++
%	make sure, there are no leading zeros !

global gfq_n

k=1;
poly=poly(:);
[l,x]=size(poly);
reg=zeros(l,1);
reg(1)=poly(1);

for i=0:gfq_n
	for j=1:l-1
		t=gfq_multiplic(reg(j),i);
		reg(j+1)=gfq_add(poly(j+1),t);
	end
	if (reg(l)==0)
		poly=reg(1:l-1);
		roots(k)=i;
		l=l-1;
		k=k+1;

		if (l==2)
			t=gfq_multiplic(gfq_invert(reg(1)),reg(2));
			roots(k)=t;
			break;
		end
	end
end
	
