function	gfq_calctabs(poly)
%
% poly is a binary polynom with msb first
% e.g [1 0 1 1] == x^3+x+1
% to create a field, poly must be irreducible in GF(2)
% first element of poly should be nonzero
% d is the degree of poly
%
% calculates table:
% global gfq_expotab
% size(1,1:2^d), Value[1:2^d-1]
% which contains the remainderpolynoms of x^i
% e.g. x^100=gfq_expotab(100+1)
% (x is an primitive element of order (2^d-1) in GF(2^d))
%
% and its counterpart:
% global gfq_logatab
% size(1,1:2^d-1), Value[0:2^d-2]
% which contains the discrete logarithm for a given value
% e.g. log_x(100)=gfq_logatab(100)

global gfq_expotab gfq_logatab gfq_n

poly=poly(:)';
[x,d]=size(poly);
gfq_n=round(exp(log(2)*(d-1))-1);
gfq_expotab=zeros(gfq_n,1);
gfq_logatab=zeros(gfq_n,1);

for i=1:gfq_n
	a=[1,zeros(1,i-1)];
	rem=div_poly(a,poly);
	for j=1:d-1
		if (rem(j)>0)
			gfq_expotab(i)=gfq_expotab(i)+round(exp(log(2)*(d-j-1)));
		end
	end
	disp(num2str(i));
end

gfq_logatab(gfq_expotab)=[0:gfq_n-1]';
