function	A=gfq_errorlocator(syndrom)
%
%	calculates the errorlocator-polynom A(x)
%	from a given syndrom in GF256
%
%	A(1,1~2*t),value [GF(q)], LSB-first
%	the zeros of A(x) are the invers errorlocations
%
%	syndrom(1,n-k),value [GF(q)], LSB-first

syndrom=syndrom(:);
[m,n]=size(syndrom);
t=fix(m/2);	% no. of correctable errors

k=0;
A=zeros(1,m);
A(1)=1;
L=0;
T=zeros(1,m);
T(2)=1;

while (k<2*t)
	Alast=A;
	k=k+1;
	D=syndrom(k);
	for i=1:L
		D=gfq_add(D,gfq_multiplic(Alast(i+1),syndrom(k-i)));
	end

	if (D>0)
		for i=1:m;
			A(i)=gfq_add(Alast(i),gfq_multiplic(D,T(i)));
		end
		if (2*L<k)
			L=k-L;
			Dinvers=gfq_invert(D);
			for i=1:m
				T(i)=gfq_multiplic(Alast(i),Dinvers);
			end
		end
	end
	T=[0,T];
end
A=A(1:L+1);