function	GF256_calctabs()
%
% creates table:
% global gfq_expotab
% size(1,1:256), Value[1:255]
% which contains the values for alpha^i
% e.g. alpha^100=gfq_expotab(100+1)=6
% where alpha is an element of order 255 in GF256
%
% and its counterpart:
% global gfq_logatab
% size(1,1:255), Value[0:254]
% which contains the discrete logarithm for a given value
% e.g. log_alpha(6)=gfq_logatab(6)=100
%
% and gfq_n which is 255

global gfq_expotab gfq_logatab gfq_n

gfq_n=255;

gfq_expotab=[
     1;     2;     4;     8;    16;    32;    64;
   128;   135;   137;   149;   173;
   221;    61;   122;   244;   111;   222;    59;
   118;   236;    95;   190;   251;
   113;   226;    67;   134;   139;   145;   165;
   205;    29;    58;   116;   232;
    87;   174;   219;    49;    98;   196;    15;
    30;    60;   120;   240;   103;
   206;    27;    54;   108;   216;    55;   110;
   220;    63;   126;   252;   127;
   254;   123;   246;   107;   214;    43;    86;
   172;   223;    57;   114;   228;
    79;   158;   187;   241;   101;   202;    19;
    38;    76;   152;   183;   233;
    85;   170;   211;    33;    66;   132;   143;
   153;   181;   237;    93;   186;
   243;    97;   194;     3;
     6;    12;    24;    48;    96;   192;     7;
    14;    28;    56;   112;   224;
    71;   142;   155;   177;   229;    77;   154;
   179;   225;    69;   138;   147;
   161;   197;    13;    26;    52;   104;   208;
    39;    78;   156;   191;   249;
   117;   234;    83;   166;   203;    17;    34;
    68;   136;   151;   169;   213;
    45;    90;   180;   239;    89;   178;   227;
    65;   130;   131;   129;   133;
   141;   157;   189;   253;   125;   250;   115;
   230;    75;   150;   171;   209;
    37;    74;   148;   175;   217;    53;   106;
   212;    47;    94;   188;   255;
   121;   242;    99;   198;    11;    22;    44;
    88;   176;   231;    73;   146;
   163;   193;     5;    10;
    20;    40;    80;   160;   199;     9;    18;
    36;    72;   144;   167;   201;
    21;    42;    84;   168;   215;    41;    82;
   164;   207;    25;    50;   100;
   200;    23;    46;    92;   184;   247;   105;
   210;    35;    70;   140;   159;
   185;   245;   109;   218;    51;   102;   204;
    31;    62;   124;   248;   119;
   238;    91;   182;   235;    81;   162;   195
];

gfq_logatab(gfq_expotab)=[0:254]';
