function	Xi=myfft_step(step,xi)
%
% performs one fft-step
%
% error compared to matlab built-in-fft: max=5.3291e-15
%
% i: no. of step, value 0..log2(N)
% Xi: vektor of values, size(N,1), value(complex)
% Xk: next values, size(N,1), value(complex)

xi=xi(:);
[mm,nn]=size(xi);

alpha=ceil(exp(log(2)*step));
x1=0;
x2=0;
fprintf('-- step %d   alpha %d\n',step,alpha);
for i=0:(mm/2-1)

	% adress calculation
	a=2*alpha*floor(i/alpha)+rem(i,alpha)+1;
	b=a+alpha;

	% operand fetch
	x1=xi(a);
	x2=xi(b);

	% calculation
	k=mm/(2*alpha)*rem((a-1),alpha);
	Wk=exp(-j*2*pi*k/mm);
	fprintf('i%3d  a%3d b%3d k%3d Wk%d+%dj\n',i,a,b,k,real(Wk),imag(Wk));
	t=x2*Wk;
	X1=x1+t;
	X2=x1-t;

	% operand store
	Xi(a)=X1;
	Xi(b)=X2;
end

