function	etina_demuxA
%
%	reads an eti-na File
%	and demuxes it
%

home='/import/home.hi213001/guest52';
etiname=[home,'/data/Na_A.eti'];
etioffset=0;
outname=[home,'/data/test_ni.eti'];

etifile=fopen(etiname,'r');
if (etifile==-1)
	disp(['error opening',etiname]);
	break;
end

fread(etifile,etioffset);
O=fread(etifile,6144);
fclose(etifile);

t=[0:191]*32+1;
G0=O(t);
G1=O(t+16);

t=[1:15]'*ones(1,384);
s=ones(15,1)*[1:16:6144];
u=s+t;
u=u(:);
I=O(u);

s1=I(1:1920);
s2=I(1921:3840);
s3=I(3841:5760);
s1=reshape(s1,8,240);
s2=reshape(s2,8,240);
s3=reshape(s3,8,240);

C=[s1;s2;s3];
M1=s1(1,[1:30:211]);
M2=s2(1,[1:30:211]);
M3=s3(1,[1:30:211]);
S1=s1(2,[1:30:211]);
S2=s2(2,[1:30:211]);
S3=s3(2,[1:30:211]);

B1=s1(1,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B2=s1(2,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B3=s1(3:8,1:235);
B3=B3';
B3=B3(:);

B4=s1(1,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B5=s1(2,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B6=s1(3:8,1:235);
B6=B6';
B6=B6(:);

B7=s1(1,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B8=s1(2,[2:30,32:60,62:90,92:120,122:150,152:180,182:210,212:235])';
B9=s1(3:8,1:235);
B9=B9';
B9=B9(:);

B=[B1;B2;B3;B4;B5;B6;B7;B8;B9];

ETI_NI=[B;zeros(552,1)+255];
size(ETI_NI)

outfile=fopen(outname,'w');
if (outfile==-1)
	disp(['Error opening ',outname]);
	break;
end
fwrite(outfile,ETI_NI,'uchar');
fclose(outfile);
disp(['written to ',outname]);
