function        cofdm_servinit(etiin)
%  matlab cofdm-client
%  sends commands via fifo to the cofdm-server
%  and reads the response out of another fifo.

global cofdm_servin cofdm_dataout cofdm_type home;


cofdm_type='float32';

% file-init
servin=[home,'/projekt/bin/sun4/servin'];
dataout=[home,'/projekt/bin/sun4/dataout'];
cofdm_servin=fopen(servin,'w+');
if cofdm_servin < 0
        text=['Error in cofdm_servinit(), cant open fifo: ',servin];
        error(text);
end

cofdm_dataout=fopen(dataout,'r+');
if cofdm_dataout < 0
        text=['Error in cofdm_servinit(), cant open fifo: ',dataout];
        error(text);
end

%      command-init
fprintf(cofdm_servin,'reset\n');
text=sprintf('outopen %s\n',dataout);
fprintf(cofdm_servin,text);
text=sprintf('etiopen %s\n',etiin);
fprintf(cofdm_servin,text);
fprintf(cofdm_servin,'etifetch 0\n');
fprintf(cofdm_servin,'etifetch 1\n');
fprintf(cofdm_servin,'etifetch 2\n');
fprintf(cofdm_servin,'etifetch 3\n');
fprintf(cofdm_servin,'etisort 0\n');
fprintf(cofdm_servin,'modeeti\n');


